/**
 * Beschreiben Sie hier die Klasse Hanoi.
 * 
 * @author (Ihr Name) 
 * @version (eine Versionsnummer oder ein Datum)
 */
public class Hanoi {

	Stapel quelle, hilf, ziel;
	Scheibe[] slice;
	int anzahl;
	int k = 1;

	public Hanoi(int n) {
		anzahl = Math.min(n, 6);
		slice = new Scheibe[6];
		slice[0] = new Scheibe(28, "rot");
		slice[1] = new Scheibe(24, "blau");
		slice[2] = new Scheibe(20, "gruen");
		slice[3] = new Scheibe(16, "gelb");
		slice[4] = new Scheibe(12, "wei");
		slice[5] = new Scheibe(8, "schwarz");

		quelle = new Stapel();
		hilf = new Stapel();
		ziel = new Stapel();
		for (int i = 0; i < anzahl; i++) {
			quelle.einfuegen(slice[i]);
		}
	}

	private void turmVerschieben(int n, Stapel q, Stapel h, Stapel z) {
		if (n > 1) {
			turmVerschieben(n - 1, q, z, h);
		}
		z.einfuegen(q.entnehmen());
		datenAusgeben();
		k = k + 1;
		hanoiZeichnen(100 * k);
		if (n > 1) {
			turmVerschieben(n - 1, h, q, z);
		}
	}

	public void hanoiturmUmstapeln() {
		datenAusgeben();
		hanoiZeichnen(100);
		turmVerschieben(anzahl, quelle, hilf, ziel);
	}

	private void datenAusgeben() {
		System.out.println("------------------------");
		System.out.println("Quellenstapel");
		quelle.alleDatenAusgeben();
		System.out.println("Hilfsstapel");
		hilf.alleDatenAusgeben();
		System.out.println("Zielstapel");
		ziel.alleDatenAusgeben();
	}

	private void hanoiZeichnen(int ypos) {
		Ausgabe a = new Ausgabe("(" + k + ")", 400, ypos - 60, 200, 100);
		quelle.reiheZeichnen(100, ypos - 10 * quelle.anzahlScheibenGeben());
		hilf.reiheZeichnen(200, ypos - 10 * hilf.anzahlScheibenGeben());
		ziel.reiheZeichnen(300, ypos - 10 * ziel.anzahlScheibenGeben());
	}

}

