public class Stein extends Baustein {
	private Baustein naechster;
	private Datenelement inhalt;

	public Stein(Baustein n, Datenelement d) {
		naechster = n;
		inhalt = d;
	}
	
	public Stein() {
	}

	public void inhaltSetzen(Datenelement d) {
		inhalt = d;
	}

	public void naechsterSetzen(Baustein n) {
		naechster = n;
	}

	public Baustein naechsterGeben() {
		return naechster;
	}

	public Datenelement inhaltGeben() {
		return inhalt;
	}

	public Stein hintenEinfgen(Datenelement e) {
		naechster = naechster.hintenEinfgen(e);
		return this;
	}

	public Datenelement inhaltLetzterGeben(Datenelement e) {
		return naechster.inhaltLetzterGeben(e);

	}

	public int gesamthoeheGeben() {
		return inhalt.hoeheGeben() + naechster.gesamthoeheGeben();
	}
	
	public  int anzahlGeben(){
	    return naechster.anzahlGeben()+1;
	   }
	   
	public String datenGeben(){
	    return "Hhe: "+ inhalt.hoeheGeben() + "  Farbe: " + inhalt.farbeGeben() +"     |     " + naechster.datenGeben();
	   }
	   
	public int relativehoeheGeben(){
	    return naechster.relativehoeheGeben();
	   }
	   
	public void zeichnen(int yOffset){
	    int temp=yOffset;
	    Rechteck r = new Rechteck(250,yOffset-inhalt.hoeheGeben(),50,inhalt.hoeheGeben());
	    r.setzeFarbe(inhalt.farbeGeben());
	    naechster.zeichnen(temp-inhalt.hoeheGeben());
	   }
	 
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
	   
}