/**
 * 
 * Eine Schrges Rechteck kann sich selbst zeichnet im Programmfenster Zeichnung
 * Breite gibt den Abstand von der Mittellinie an
 * Um die Endpunkte eine Kreis als Gelenk
 * 
 * @author Hans Witt
 * 
 * @version: 3.2 (30.8.2008)
 * 
 */
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;

public class Pfeil {
	
	private CPfeil	obj;
	protected int		x1			= 0;
	protected int		y1			= 0;
	protected int		x2			= 100;
	protected int		y2			= 50;
	protected boolean	sichtbar	= true;
	protected String	farbe		= StaticTools.leseNormalfarbe();
	protected int		breite		= 4;
	
	protected boolean	spitzeStart	= false;
	protected boolean	spitzeEnde	= true;
	
	/**
	 * Konstruktor fr Hauptfenster
	 */
	public Pfeil() {
		this(Zeichnung.gibZeichenflaeche());
	}
	
	/**
	 * Konstruktor fr Hauptfenster
	 * 
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 */
	public Pfeil(int x1, int y1, int x2, int y2) {
		this(Zeichnung.gibZeichenflaeche(), x1, y1, x2, y2);
	}
	
	/**
	 * Konstruktor
	 * 
	 * @param behaelter
	 */
	public Pfeil(IContainer behaelter) {
		this(behaelter, 0, 0, 100, 50);
	}
	
	/**
	 * allgemeiner Konstruktor
	 * 
	 * @param behaelter
	 * @param x2
	 * @param y2
	 */
	public Pfeil(IContainer behaelter, int x1, int y1, int x2, int y2) {
		obj = new CPfeil();
		behaelter.add(obj, 0);
		setzeEndpunkte(x1, y1, x2, y2);
		behaelter.validate();
	}
	
	public void sichtbarMachen() {
		sichtbar = true;
		obj.sichtbarMachen();
	}
	
	/**
	 * Mache unsichtbar. Wenn es bereits unsichtbar ist, tue nichts.
	 */
	public void unsichtbarMachen() {
		sichtbar = false;
		obj.unsichtbarMachen();
	}
	
	/**
	 * 
	 * @param neuesX1
	 * @param neuesY1
	 * @param neuesX2
	 * @param neuesY2
	 */
	public void setzeEndpunkte(int neuesX1, int neuesY1, int neuesX2,
			int neuesY2) {
		x1 = neuesX1;
		y1 = neuesY1;
		x2 = neuesX2;
		y2 = neuesY2;
		obj.setzeEndpunkte(x1, y1, x2, y2);
	}
	
	/*
	 * gltige Farben: "rot", "gelb", "blau", "gruen", "lila" , "schwarz" ,
	 * "weiss" , "grau","pink","magenta","orange","cyan","hellgrau"
	 */
	public void setzeFarbe(String neueFarbe) {
		farbe = neueFarbe;
		obj.setzeBasisfarbe(neueFarbe);
	}
	
	/**
	 * Liniendicke setzen
	 * 
	 * @param neueDicke
	 */
	public void setzeBreite(int neueBreite) {
		breite = neueBreite;
		obj.setzeBreite(breite);
	}
	
	/**
	 * Enden setzen
	 * 
	 * @param start
	 * @param ende
	 */
	public void setzeEnden(boolean start, boolean ende) {
		spitzeStart = start;
		spitzeEnde = ende;
		obj.setzeEnde(spitzeStart, spitzeEnde);
	}
	public static void main(String[] args) {
		Pfeil t = new Pfeil();
		t.setzeEndpunkte(100,300,200,100);
		t.setzeFarbe("blau");
		t.setzeEnden(true, true);
	}

		
}

class CPfeil extends BasisComponente {
	
	private int			pfeilBreite	= 50;
	private int			spitze		= 3;
	
	protected boolean	spitzeStart	= false;
	protected boolean	spitzeEnde	= true;
	
	int[]				xpoints		= new int[10];
	int[]				ypoints		= new int[10];
	
	/**
	 * Konstruktor ohne Beschriftung
	 */
	public CPfeil() {
		
	}
	
	/**
	 * Die Darstellung der Komponente wird hier programmiert.
	 */
	
	public void paintComponentSpezial(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		// Graphik-Abmessungen
		breite = getSize().width;
		hoehe = getSize().height;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2.setStroke(new BasicStroke(2, BasicStroke.CAP_ROUND,
				BasicStroke.JOIN_MITER));
		g2.setColor(farbe);
		if (gefuellt) {
			g2.fillPolygon(new Polygon(xpoints, ypoints, 10));
		} else {
			g2.drawPolygon(new Polygon(xpoints, ypoints, 10));
		}
		
	
	}
	
	int startX = 0 ;
	int startY = 0 ;
	int endeX = 0 ;
	int endeY = 0 ;
	
	int	relStartX	= 10;
	int	relStartY	= 10;
	int	relEndeX	= 100;
	int	relEndY	= 100;
	
	// Das Rechteck um die Verbindungslinie hat doppelte Pfeilbreite
	public void setzeEndpunkte(int neuesX1, int neuesY1, int neuesX2,
			int neuesY2) {
		startX = neuesX1 ;
		startY = neuesY1 ;
		endeX = neuesX2 ;
		endeY = neuesY2;
		
		if (neuesX1 < neuesX2) {
			xPos = neuesX1 - pfeilBreite * spitze;
			breite = neuesX2 - neuesX1 + 2 * spitze * pfeilBreite;
		} else {
			xPos = neuesX2 - pfeilBreite * 2;
			breite = neuesX1 - neuesX2 + 2 * spitze * pfeilBreite;
		}
		if (neuesY1 < neuesY2) {
			yPos = neuesY1 - pfeilBreite * spitze;
			hoehe = neuesY2 - neuesY1 + 2 * spitze * pfeilBreite;
		} else {
			hoehe = neuesY1 - neuesY2 + 2 * spitze * pfeilBreite;
			yPos = neuesY2 - pfeilBreite * spitze;
		}
		
		relStartX = neuesX1 - xPos;
		relStartY = neuesY1 - yPos;
		relEndeX = neuesX2 - xPos;
		relEndY = neuesY2 - yPos;
		setzeKoordinaten();
		
		super.setzeDimensionen(xPos, yPos, breite, hoehe);
	}
	
	public void setzeBreite(int neueBreite) {
		pfeilBreite = neueBreite;
		setzeEndpunkte( startX,startY,endeX,endeY);
	}

	/**
	 * Enden setzen
	 * 
	 * @param start
	 * @param ende
	 */
	public void setzeEnde(boolean start, boolean ende) {
		spitzeStart = start;
		spitzeEnde = ende;
		setzeKoordinaten();
	}
	
	public void setzeKoordinaten() {
		
		int dx = relEndeX - relStartX;
		int dy = relEndY - relStartY;
		
		double f = ((double) 0.5 * pfeilBreite)
				/ (Math.sqrt(dx * dx + dy * dy));
		
		double bx = dy * f;
		double by = dx * f;
		
		xpoints[0] = relStartX;
		ypoints[0] = relStartY;
		
		if (spitzeStart) {
			xpoints[1] = relStartX + (int) (-spitze * bx + spitze * by);
			ypoints[1] = relStartY + (int) (+spitze * by + spitze * bx);
		} else {
			xpoints[1] = relStartX + (int) (-bx);
			ypoints[1] = relStartY + (int) (by);
		}
		
		xpoints[2] = relStartX + (int) (-bx + spitze * by);
		ypoints[2] = relStartY + (int) (by + spitze * bx);
		
		xpoints[3] = relEndeX + (int) (-bx - spitze * by);
		ypoints[3] = relEndY + (int) (by - spitze * bx);
		
		if (spitzeEnde) {
			xpoints[4] = relEndeX + (int) (-spitze * bx - spitze * by);
			ypoints[4] = relEndY + (int) (spitze * by - spitze * bx);
		} else {
			xpoints[4] = relEndeX + (int) (-bx);
			ypoints[4] = relEndY + (int) (by);
		}
		
		xpoints[5] = relEndeX;
		ypoints[5] = relEndY;
		
		if (spitzeEnde) {
			xpoints[6] = relEndeX + (int) (+spitze * bx - spitze * by);
			ypoints[6] = relEndY + (int) (-spitze * by - spitze * bx);
		} else {
			xpoints[6] = relEndeX + (int) (+bx);
			ypoints[6] = relEndY + (int) (-by);
		}
		
		xpoints[7] = relEndeX + (int) (+bx - spitze * by);
		ypoints[7] = relEndY + (int) (-by - spitze * bx);
		
		xpoints[8] = relStartX + (int) (+bx + spitze * by);
		ypoints[8] = relStartY + (int) (-by + spitze * bx);
		
		if (spitzeStart) {
			xpoints[9] = relStartX + (int) (+spitze * bx + spitze * by);
			ypoints[9] = relStartY + (int) (-spitze * by + spitze * bx);
		} else {
			xpoints[9] = relStartX + (int) (+bx);
			ypoints[9] = relStartY + (int) (-by);
		}
	repaint();
	}
}
