/**
 * Eine Linie kann sich selbst zeichnen im Programmfenster Zeichnung
 * 
 * @author Hans Witt
 * 
 * @version: 3.2 (18.8.2008)
 * 
 */
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class Linie {

	private CLinie obj;
	protected int x1 = 0;
	protected int y1 = 0;
	protected int x2 = 100;
	protected int y2 = 50;
	protected boolean sichtbar = true;
	protected String farbe = StaticTools.leseNormalfarbe();
	protected int linienDicke = 4;

	/**
	 * Konstruktor fr Hauptfenster
	 */
	public Linie() {
		this(Zeichnung.gibZeichenflaeche());
	}

	/**
	 * Konstruktor fr Hauptfenster
	 * 
	 * @param x1
	 * @param y1
	 * @param x2
	 * @param y2
	 */
	public Linie(int x1, int y1, int x2, int y2) {
		this(Zeichnung.gibZeichenflaeche(), x1, y1, x2, y2);
	}

	/**
	 * Konstruktor
	 * 
	 * @param behaelter
	 */
	public Linie(IContainer behaelter) {
		this(behaelter, 0, 0, 100, 50);
	}

	/**
	 * allgemeiner Konstruktor
	 * 
	 * @param behaelter
	 * @param x2
	 * @param y2
	 */
	public Linie(IContainer behaelter, int x1, int y1, int x2, int y2) {
		obj = new CLinie();
		behaelter.add(obj, 0);
		setzeEndpunkte(x1, y1, x2, y2);
		behaelter.validate();
	}

	public void sichtbarMachen() {
		sichtbar = true;
		obj.sichtbarMachen();
	}

	/**
	 * Mache unsichtbar. Wenn es bereits unsichtbar ist, tue nichts.
	 */
	public void unsichtbarMachen() {
		sichtbar = false;
		obj.unsichtbarMachen();
	}


	/**
	 * 
	 * @param neuesX1
	 * @param neuesY1
	 * @param neuesX2
	 * @param neuesY2
	 */
	public void setzeEndpunkte(int neuesX1, int neuesY1, int neuesX2,
			int neuesY2) {
		x1 = neuesX1;
		y1 = neuesY1;
		x2 = neuesX2;
		y2 = neuesY2;
		obj.setzeEndpunkte(x1, y1, x2, y2);
	}

	/*
	 * gltige Farben: "rot", "gelb", "blau", "gruen", "lila" , "schwarz" ,
	 * "weiss" , "grau","pink","magenta","orange","cyan","hellgrau"
	 */
	public void setzeFarbe(String neueFarbe) {
		farbe = neueFarbe;
		obj.setzeBasisfarbe(neueFarbe);
	}

	/**
	 * Liniendicke setzen
	 * 
	 * @param neueDicke
	 */
	public void setzeLinienDicke(int neueDicke) {
		linienDicke = neueDicke;
		obj.setzeLinienDicke(linienDicke);
	}
}

class CLinie extends BasisComponente {

	private int linienDicke = 4;

	public void setzeLinienDicke(int neueDicke) {
		int differenz = neueDicke - linienDicke ;
		linienDicke = neueDicke;
		xPos -= differenz ;
		yPos -= differenz ;
		breite = breite + 2 * differenz ;
		hoehe = hoehe + 2 * differenz ;
		
		startX += differenz;
		startY += differenz;
		endX += differenz;
		endY += differenz;
		super.setzeDimensionen(xPos, yPos, breite, hoehe);
	}

	/**
	 * Konstruktor ohne Beschriftung
	 */
	public CLinie() {

	}

	/**
	 * Die Darstellung der Komponente wird hier programmiert.
	 */

	public void paintComponentSpezial(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		// Graphik-Abmessungen
		breite = getSize().width;
		hoehe = getSize().height;
		g.setColor(farbe);
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);

		g2.setStroke(new BasicStroke(linienDicke, BasicStroke.CAP_ROUND,
				BasicStroke.JOIN_MITER));

		g2.drawLine(startX, startY, endX, endY);
	}

	int startX = 10;
	int startY = 10;
	int endX = 100;
	int endY = 100;

	public void setzeEndpunkte(int neuesX1, int neuesY1, int neuesX2,
			int neuesY2) {
		if (neuesX1 < neuesX2) {
			xPos = neuesX1 - linienDicke;
			breite = neuesX2 - neuesX1 + 2 * linienDicke;
		} else {
			xPos = neuesX2 - linienDicke;
			breite = neuesX1 - neuesX2 + 2 * linienDicke;
		}
		if (neuesY1 < neuesY2) {
			yPos = neuesY1 - linienDicke;
			hoehe = neuesY2 - neuesY1 + 2 * linienDicke;
		} else {
			hoehe = neuesY1 - neuesY2 + 2 * linienDicke;
			yPos = neuesY2 - linienDicke;
		}

		startX = neuesX1 - xPos;
		startY = neuesY1 - yPos;
		endX = neuesX2 - xPos;
		endY = neuesY2 - yPos;

		super.setzeDimensionen(xPos, yPos, breite, hoehe);
	}

}