/**
 * Muster einer Komponente, in die man direkt zeichnen kann.
 * Die Komponente kann sich selbst zeichnen im Programmfenster Zeichnung
 * 
 * @author Hans Witt
 * 
 * Version 1.1 (14.7.2008)
 * Version: 1.1.1 (17.7.2008) 
 *        Neue Komponenten werden von Unten nach Oben aufgebaut, d.h.vor die alten gesetzt
 * Version: 3 (9.8.2008) 
 *        Containerklasse fr GUI-Elemente
 * Version: 3.1 (14.8.2008) 
 *        Konstruktor auf int neuesX, int neuesY , int neueBreite, int neueHoehe angepasst		
 * @version: 3.2 (18.8.2008)
 *        Zustandsvariable auf protected gesetzt 
 */

import java.awt.Graphics;
import java.awt.Graphics2D;

public class FreiZeichnen extends BasisComponente {
	protected int breite = 100;
	protected int hoehe = 100;
	protected int xPos = 0;
	protected int yPos = 0;
	protected String strFarbe = StaticTools.leseNormalfarbe();

	/**
	 * Konstruktor fr Hauptfenster
	 */
	public FreiZeichnen() {
		this(Zeichnung.gibZeichenflaeche());
	}

	/**
	 * Konstruktor fr Hauptfenster
	 * 
	 * @param neueBreite
	 * @param neueHoehe
	 */
	public FreiZeichnen(int neueBreite, int neueHoehe) {
		this(Zeichnung.gibZeichenflaeche(), 0, 0, neueBreite, neueHoehe);
	}

	/**
	 * Konstruktor fr Hauptfenster
	 * 
	 * @param neuesX
	 * @param neuesY
	 * @param neueBreite
	 * @param neueHoehe
	 */
	public FreiZeichnen(int neuesX, int neuesY, int neueBreite, int neueHoehe) {
		this(Zeichnung.gibZeichenflaeche(), neuesX, neuesY, neueBreite,
				neueHoehe);
	}

	/**
	 * Konstruktor
	 * 
	 * @param behaelter
	 */
	public FreiZeichnen(IContainer behaelter) {
		this(behaelter, 0, 0, 100, 100);
	}

	/**
	 * allgemeiner Konstruktor
	 * 
	 * @param behaelter
	 * @param neueBreite
	 * @param neueHoehe
	 */
	public FreiZeichnen(IContainer behaelter, int neuesX, int neuesY,
			int neueBreite, int neueHoehe) {
		behaelter.add(this, 0);
		setzeDimensionen(neuesX, neuesY, neueBreite, neueHoehe);
		behaelter.validate();
	}

	/**
	 * Die Darstellung der Komponente wird hier programmiert.
	 */

	public void paintComponentSpezial(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		// Graphik-Abmessungen
		breite = getSize().width - 2;
		hoehe = getSize().height - 2;
		g.setColor(farbe);

		int mitteX = breite / 2;
		int mitteY = hoehe / 2;

		// Zeichnet eine Linie zwischen den Koordinaten (x1,y1) und (x2,y2) in
		// der Vordergrundfarbe.
		// void drawLine( int x1, int y1, int x2, int y2 )

		int anzahl = 10;
		int x = 0;
		int y = 0;

		for (int i = 1; i <= anzahl; i++) {
			x = (int) Math.round(breite / 2
					* Math.cos(i * 2 * Math.PI / anzahl));
			y = (int) Math.round(breite / 2
					* Math.sin(i * 2 * Math.PI / anzahl));
			g2.drawLine(mitteX, mitteY, mitteX + x, mitteY - y);
		}
	}

	/*
	 * gltige Farben: "rot", "gelb", "blau", "gruen", "lila" , "schwarz" ,
	 * "weiss" , "grau","pink","magenta","orange","cyan","hellgrau"
	 */
	public void setzeFarbe(String neueFarbe) {
		strFarbe = neueFarbe;
		super.setzeBasisfarbe(neueFarbe);
	}

	public static void main(String[] args) {
		FreiZeichnen d = new FreiZeichnen(50, 50, 300, 300);

		d.setzeFarbe("blau");
	}

}
